# TV Provider Authentication End-to-End Example

This example code package will get you up and running with a sample TV Provider and client application.

1. Host the IdP and SP folders on a webserver accessible to test devices.
2. Connect your iOS/iPadOS/tvOS device to your Mac and open Xcode to enable the Developer settings menu.
3. Navigate to Settings > Developer > TV Provider and select Add TV Provider
   1. Name: Test TV Provider
   2. Identifier: test.tvprovider.api
   3. Auth URL: http://yourserver/IdP/application.js
   4. Auth Scheme: SAML OFF, API ON
4. Update the Endpoint struct in Utilities.swift to point to your newly hosted SP files.
```swift
struct Endpoints {
    static let verificationToken = "https://yourserver/SP/verificationToken?providerID="
    static let authentication = "https://yourserver/SP/authN"
    static let authorization = "https://yourserver/SP/authZ"
}
```
5. Configure the appropriate team, code signing, and provisioning profile settings.
6. Build and run.

# Questions? Need Help?

Reach out to your Apple contact with any questions regarding this sample project.
